:

# Test if r2sync updates (relatively) big files.

trap 'rm -rf $TMP1 $TMP2' 0
TMP1=`mktemp /tmp/test-XXXXXX` || exit 1
TMP2=`mktemp /tmp/test-XXXXXX` || exit 1

# Make TMP1 a "big" file, at least bigger than the default block size
# of 1024 bytes. Make $TMP2 a different big file.
#
for i in `seq 1 1024`; do echo "abcdefghijklmnopqrstuvwxyz"; done >$TMP1
for i in `seq 1 1024`; do echo "0123456789"; done >$TMP1

# Let r2sync synchronize them.
#
./r2sync -b -c '>' $TMP1 $TMP2 || exit 1

# Remove the logs.
#
./r2sync -b -r $TMP1 $TMP2 || exit 1

# Check that the files are the same
#
diff -u $TMP1 $TMP2
