:

# Test r2sync running in batch mode.

trap 'rm -rf $TMPDIR1 $TMPDIR2' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1

set -vx

ok=true

# Create two files in $TMPDIR2 and synchronize them to $TMPDIR1
#
echo "File 1" >$TMPDIR2/file-1
echo "File 2" >$TMPDIR2/file-2
./r2sync -b $TMPDIR1 $TMPDIR2 || ok=false

# Check that the files exist in $TMPDIR2 and are the same.
#
if ! cmp -s $TMPDIR1/file-1 $TMPDIR2/file-1; then
  ok=false
fi
if ! cmp -s $TMPDIR1/file-2 $TMPDIR2/file-2; then
  ok=false
fi

# Modify one of the files and synchronize again.
#
echo "Updated file 2" >$TMPDIR2/file-2
./r2sync -b $TMPDIR1 $TMPDIR2 || ok=false

# Check that the files in $TMPDIR1 and $TMPDIR2 are the same again.
#
if ! cmp -s $TMPDIR1/file-1 $TMPDIR2/file-1; then
  ok=false
fi
if ! cmp -s $TMPDIR1/file-2 $TMPDIR2/file-2; then
  ok=false
fi

# Let r2sync remove the log file.
#
./r2sync -b -r $TMPDIR1 $TMPDIR2 || ok=false

# Return test result.
#
if ! $ok; then exit 1; fi
