:

# Check that r2sync handles the -a option.

echo "## Create two directories and a temporary file."
trap 'rm -rf $TMPDIR1 $TMPDIR2 $TMP' 0
TMPDIR1=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMPDIR2=`mktemp -d /tmp/test-XXXXXX` || exit 1
TMP=`mktemp /tmp/test-XXXXXX` || exit 1

ok=true

echo "## Put some files in TMPDIR1."
echo "Test" >$TMPDIR1/test-file-1
echo "Test test" >$TMPDIR1/test-file-2
echo "Test test test" >$TMPDIR1/test-file-3

echo "## Let r2sync copy TMPDIR1 to TMPDIR2:"
echo "##"
./r2sync -b -c '>' $TMPDIR1 $TMPDIR2 || exit 1

echo
echo "## Modify test-file-2 in both directories in identical ways."
echo "Modified" >$TMPDIR1/test-file-2
echo "Modified" >$TMPDIR2/test-file-2
touch -r $TMPDIR1/test-file-2 $TMPDIR2/test-file-2

echo "## Modify test-file-3 in both directories in different ways,"
echo "## but with the same size and time."
echo "Modified1" >$TMPDIR1/test-file-3
echo "Modified2" >$TMPDIR2/test-file-3
touch -r $TMPDIR1/test-file-3 $TMPDIR2/test-file-3

echo "## Let r2sync synchronize the directories without -a."
echo "## It should report 2 files to synchronize:"
echo "##"
./r2sync -b $TMPDIR1 $TMPDIR2 >$TMP
cat $TMP
grep -Fq 'Found 2 files to synchronize' $TMP
if [ $? != 0 ]; then ok=false; echo "## FAILED!"; fi

echo
echo "## Let r2sync synchronize the directories with -a."
echo "## It should report 1 different file and one updated, identical file:"
echo "##"
./r2sync -b -a $TMPDIR1 $TMPDIR2 >$TMP
cat $TMP
grep -Fq 'Found 1 updated but identical file' $TMP
if [ $? != 0 ]; then ok=false; echo "## FAILED!"; fi
grep -Fq 'Found 1 different file' $TMP
if [ $? != 0 ]; then ok=false; echo "## FAILED!"; fi

echo
echo "## Remove the logs:"
echo "##"
./r2sync -b -r $TMPDIR1 $TMPDIR2 || ok=false

# Report the result.
#
echo
$ok
