/*
  get_lstat() is called by serve1() after an "lstat" command to
  retrieve and print the mode, modification time and size of a file.
*/

#include "stdincls.h"
#include "errcodes.e"
#include "types.e"
#include "print.e"


/* get_lstat -- print mode, modification time and size of a file */
EXPORT void get_lstat(FILE *out, const char *root, const char *arg)
{
  struct stat statbuf;
  char path[FILENAME_MAX+1];

  /* arg points to the argument of the "lstat" command. It may be empty. */
  if (!make_absolute(root, arg, path)) {
    print(out, "? %03d Path too long\n", EC_TOOLONG);
    return;
  }

  if (lstat(path, &statbuf) == -1) {
    print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
    return;
  }

  print(out, "= %ho %ld %lld\n", statbuf.st_mode, statbuf.st_mtime,
	(long long)statbuf.st_size);
}
