/*
  delete_file() is called by serve1() after a "del" command to delete
  the given file.

  Implementation:

  delete_file() deletes the file (it's an error if the file doesn't
  exist) and then removes the file from the log (it's Ok if it already
  wasn't in the log).
*/

#include "stdincls.h"
#include "errcodes.e"
#include "print.e"
#include "types.e"
#include "s-store.e"


/* delete_file -- delete a file, report result, update the log */
EXPORT void delete_file(FILE *out, const char *root, const char *arg, DB store)
{
  char path[FILENAME_MAX+1];

  /* arg points to the argument of the "del" command. It may be empty. */
  if (!make_absolute(root, arg, path)) {
    print(out, "? %03d Path too long\n", EC_TOOLONG);
    return;
  }

  /* Delete the file, if it exists. */
  if (remove(path) == -1 && errno != ENOENT) {
    print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
    return;
  }

  /* Return success and update the log. */
  (void) print1(out, "OK\n");
  (void) store_del(store, arg);
}
