/*
  change_mode() is called by serve1() after a "chmod" command to set
  the permission bits of a file.
*/

#include "stdincls.h"
#include "errcodes.e"
#include "print.e"
#include "types.e"
#include "s-store.e"
#include "s-updatelog.e"
#include "s-sumfile.e"


/* change_mode -- change the permission bits of a file */
EXPORT void change_mode(FILE *out, char * const root, const unsigned int mode,
			char * const file, DB const store)
{
  char path[FILENAME_MAX+1];
  unsigned int oldmode;
  struct stat statbuf;
  fileinfo info;
  bool in_store;

  assert(mode <= 07777);

  if (!make_absolute(root, file, path)) {
    print(out, "? %03d Path too long\n", EC_TOOLONG);
    return;
  }

  /* Get the type of file, from the log or with lstat(). */
  if (store_get(store, file, &info)) {
    in_store = true;
    oldmode = info.mode;
  } else if (lstat(path, &statbuf) == -1) {
    print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
    return;
  } else {
    in_store = false;
    oldmode = statbuf.st_mode;
  }

  /* Verify that file is a regular file */
  if (!S_ISREG(oldmode)) {
    print(out, "? %03d Can only set mode of a regular file\n", EC_CHMOD);
    return;
  }

  /* Set the new mode bits */
  if (chmod(path, mode) == -1) {
    print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
    return;
  }

  /* If there is no entry in the log yet, create one. */
  if (!in_store) {
    info.status = '-';		/* Indicate that info.sums is empty */
    info.mode = statbuf.st_mode;
    info.time = statbuf.st_mtime;
    info.size = statbuf.st_size;
    if (!(info.path = strdup(file))) {
      print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
      return;
    }
  }

  /* Update log */
  info.mode = (info.mode & S_IFMT) | mode;
  if (store_put(store, info)) print1(out, "OK\n");
  else print(out, "? %03d %s\n", EC_SERVER + errno, strerror(errno));
}
