/*
  print_statistics() is called by client() to show the total sizes of
  the files on both roots and the number of bytes received from the
  daemons for those roots.
*/

#include "stdincls.h"
#include "types.e"
#include "print.e"
#include "getline.e"
#include "c-profile.e"


/* print_statistics -- print some statistics */
EXPORT void print_statistics(Profile profile, fileinfo files1[], int nfiles1,
			     fileinfo files2[], int nfiles2)
{
  long long s1, s2, to1, to2, from1, from2;
  float speed1, speed2;
  int i;
  time_t now = time(NULL);

  for (s1 = 0, i = 0; i < nfiles1; i++) s1 += files1[i].size;
  for (s2 = 0, i = 0; i < nfiles2; i++) s2 += files2[i].size;

  to1 = get_bytes_sent(fileno(profile->to1));
  to2 = get_bytes_sent(fileno(profile->to2));
  from1 = get_bytes_received(fileno(profile->from1));
  from2 = get_bytes_received(fileno(profile->from2));

  printf("\n  1 = %s\n  2 = %s\n\n", profile->root1, profile->root2);
  printf("  %9s %20s %20s %20s\n",
	 _("Files"), _("Total size of files"), _("Bytes received"), _("Bytes sent"));
  printf("--------------------------------------------------------------------------\n");
  printf("1 %'9d %'20lld %'20lld %'20lld\n", nfiles1, s1, from1, to1);
  printf("2 %'9d %'20lld %'20lld %'20lld\n", nfiles2, s2, from2, to2);

  if (now == profile->start) {
    printf(_("\n  speed not measured (less than 1 second)\n\n"));
  } else {
    speed1 = (to1 - profile->sent1) / 1024.0 / (now - profile->start);
    speed2 = (to2 - profile->sent2) / 1024.0 / (now - profile->start);
    /* l10n: %s is either "KB" or "MB". */
    printf(_("\n  speed 1->2 = %1$.3g %2$s    speed 2->1 = %3$.3g %4$s\n\n"),
	   speed1 < 1000.0 ? speed1 : speed1 / 1024,
	   speed1 < 1000.0 ? "KB/s" : "MB/s",
	   speed2 < 1000.0 ? speed2 : speed2 / 1024,
	   speed2 < 1000.0 ? "KB/s" : "MB/s");
  }
}
