:

set -vx

# Check that the file modification times are the same after a
# synchronization.

trap 'rm -f $TMP1 $TMP2' 0
TMP1=`mktemp /tmp/test-XXXX` || exit 1
TMP2=`mktemp /tmp/test-XXXX` || exit 1

ok=true

# Make two files with different modification times
#
echo test >$TMP1
echo test test >$TMP2
touch -t 201803050000 $TMP2

# Get their metadata
#
x1=`ls -l $TMP1 | sed -e "s|$TMP1||"`
x2=`ls -l $TMP2 | sed -e "s|$TMP2||"`

# Check that they are different.
#
if [ "$x1" == "$x2" ]; then ok=false; fi

# Synchronize them
#
./r2sync -b -c '<' $TMP1 $TMP2 || ok=false

# Get their time again
#
x1=`ls -l $TMP1 | sed -e "s|$TMP1||"`
x2=`ls -l $TMP2 | sed -e "s|$TMP2||"`

# Check that they are the same.
#
if [ "$x1" != "$x2" ]; then ok=false; fi

# Remove the log.
#
./r2sync -b -r $TMP1 $TMP2 || ok=false

if ! $ok; then exit 1; fi
