:

# Test for lstat

set -v

trap 'rm -rf $TMPDIR' 0
TMPDIR=`mktemp -d /tmp/test-XXXXXX` || exit 1

# Create a file with a known size and known permission bits

echo Test >$TMPDIR/test
chmod 0600 $TMPDIR/test
size=`wc -c <$TMPDIR/test`

./r2sync -d >$TMPDIR/out <<EOF
local $TMPDIR
lstat test
EOF

cat $TMPDIR/out

# Check that the size and the mode are reported correctly

set -- `grep = $TMPDIR/out`
test "$2" = 100600 || exit 1
test "$4" = $size || exit 1
