/*
  file_checksum_and_digest() is called by compute_delta().
  It computes the checksum and the digest for a whole file.
*/

#include "stdincls.h"
#include "types.e"
#include "s-digest.e"
#include "s-checksum.e"


/* file_checksum_and_digest -- compute checksum and digest for a whole file */
EXPORT bool file_checksum_and_digest(const char *path, uint32_t *checksum,
				     unsigned char digest[DIGEST_LEN])
{
  unsigned char buf[65536];
  checksum_state c;
  digest_state s;
  ssize_t n;
  int fd;

  checksum_init(&c);
  digest_init(&s);

  if ((fd = open(path, O_RDONLY)) == -1) return false;
  while ((n = read(fd, buf, sizeof(buf))) > 0) {
    checksum_update(c, buf, n);
    digest_update(s, buf, n);
  }
  (void) close(fd);

  checksum_final(c, checksum);
  digest_final(s, digest);

  return n != -1 && !signaled;
}
